<?php
require_once 'admin_config.php';
requireAdminAuth(); // Ensure only admins can access this page

$success = false;
$error = '';
$users = [];
$services = [];

// Fetch all users and services for dropdowns
try {
    $conn = getAdminDBConnection();
    
    // Get users
    $stmt = $conn->prepare("SELECT id, username, full_name FROM users ORDER BY username");
    if ($stmt === false) {
        throw new Exception('Prepare users statement failed: ' . $conn->error);
    }
    $stmt->execute();
    $result = $stmt->get_result();
    while ($row = $result->fetch_assoc()) {
        $users[] = $row;
    }
    $stmt->close();

    // Get services
    $stmt = $conn->prepare("SELECT id, title, price FROM services ORDER BY title");
    if ($stmt === false) {
        throw new Exception('Prepare services statement failed: ' . $conn->error);
    }
    $stmt->execute();
    $result = $stmt->get_result();
    while ($row = $result->fetch_assoc()) {
        $services[] = $row;
    }
    $stmt->close();

} catch (Exception $e) {
    $error = 'خطأ أثناء تحميل البيانات: ' . $e->getMessage();
}

// Handle form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $user_id = intval($_POST['user_id'] ?? 0);
    $service_name = trim($_POST['service_name'] ?? '');
    $amount = floatval($_POST['amount'] ?? 0);
    $status = trim($_POST['status'] ?? 'pending');

    if ($user_id <= 0 || empty($service_name) || $amount <= 0) {
        $error = 'يرجى ملء جميع الحقول المطلوبة بشكل صحيح.';
    } else {
        try {
            $conn = getAdminDBConnection();
            
            // Insert the new order
            $stmt = $conn->prepare("INSERT INTO orders (user_id, service_name, amount, status, created_at) VALUES (?, ?, ?, ?, NOW())");
            if ($stmt === false) {
                throw new Exception('Prepare insert statement failed: ' . $conn->error);
            }

            $stmt->bind_param('isds', $user_id, $service_name, $amount, $status);

            if ($stmt->execute()) {
                $message = 'تم إضافة الطلب بنجاح!';
                $message_type = 'success';
                header('Location: admin_orders.php?message=' . urlencode($message) . '&type=' . $message_type);
                exit();
            } else {
                $error = 'حدث خطأ أثناء إضافة الطلب: ' . $conn->error;
            }
            $stmt->close();
        } catch (Exception $e) {
            $error = 'خطأ: ' . $e->getMessage();
        }
    }
}

require_once '../header.php';
?>

<div class="container bg-dark text-white mt-5">
    <div class="card">
        <div class="card-header">
            <h3 class="mb-0">إضافة طلب جديد</h3>
        </div>
        <div class="card-body">
            <?php if (!empty($message)): ?>
                <div class="alert alert-<?= htmlspecialchars($message_type) ?>" role="alert">
                    <?= htmlspecialchars($message) ?>
                </div>
            <?php elseif ($error): ?>
                <div class="alert alert-danger" role="alert">
                    <?= htmlspecialchars($error) ?>
                </div>
            <?php endif; ?>

            <form method="POST">
                <div class="mb-3">
                    <label for="user_id" class="form-label">المستخدم <span class="text-danger">*</span></label>
                    <select class="form-select" id="user_id" name="user_id" required>
                        <option value="">اختر المستخدم</option>
                        <?php foreach ($users as $user): ?>
                            <option value="<?= htmlspecialchars($user['id']) ?>" <?= (($_POST['user_id'] ?? '') == $user['id']) ? 'selected' : '' ?>>
                                <?= htmlspecialchars($user['username']) ?> (<?= htmlspecialchars($user['full_name']) ?>)
                            </option>
                        <?php endforeach; ?>
                    </select>
                </div>
                <div class="mb-3">
                    <label for="service_name" class="form-label">الخدمة <span class="text-danger">*</span></label>
                    <input type="text" class="form-control" id="service_name" name="service_name" value="<?= htmlspecialchars($_POST['service_name'] ?? '') ?>" required>
                </div>
                <div class="mb-3">
                    <label for="amount" class="form-label">المبلغ <span class="text-danger">*</span></label>
                    <input type="number" step="0.01" class="form-control" id="amount" name="amount" value="<?= htmlspecialchars($_POST['amount'] ?? '') ?>" required>
                </div>
                <div class="mb-3">
                    <label for="status" class="form-label">الحالة</label>
                    <select class="form-select" id="status" name="status">
                        <option value="pending" <?= (($_POST['status'] ?? '') === 'pending') ? 'selected' : '' ?>>قيد الانتظار</option>
                        <option value="completed" <?= (($_POST['status'] ?? '') === 'completed') ? 'selected' : '' ?>>مكتمل</option>
                        <option value="cancelled" <?= (($_POST['status'] ?? '') === 'cancelled') ? 'selected' : '' ?>>ملغي</option>
                    </select>
                </div>
                <button type="submit" class="btn btn-primary">إضافة الطلب</button>
                <a href="admin_orders.php" class="btn btn-secondary">إلغاء</a>
            </form>
        </div>
    </div>
</div>

<?php require_once 'footer.php'; ?> 